package kom.itbeankit.common.vcr;

import java.awt.*;
import java.awt.event.*;

class VCRClock extends Thread
{
   private ActionListener actionListener = null;

   protected String actionCommand = new String();
   protected long DelayTime;

   public VCRClock(long newDelay)
   {
      setDelayTime(newDelay);
      setPriority(MIN_PRIORITY);
   }


   public void run ()
   {
      try {
         for (;;) {
            sourceActionEvent();
            sleep(5 * Math.round(Math.sqrt((double)DelayTime)));
         } /* endfor */
      } /* endtry */
      catch (InterruptedException e) {
         return;
      } /* endcatch */
   }


   /**
    * Sets the command name of the action event fired by this button.
    * @param command: The name of the action event command fired by this button
    * @see: #getActionCommand
    */
   public void setActionCommand(String command)
   {
      actionCommand = command;
   }


   /**
    * Returns the command name of the action event fired by this button.
    * @see #setActionCommand
    */
   public String getActionCommand()
   {
       return actionCommand;
   }


   /**
    * Sets the delay time of this thread. Values below one is treated as one.
    * @param newDelay: The delay time of this thread
    * @see: #getDelayTime
    */
   public void setDelayTime(long newDelay)
   {
      if (newDelay < 1) {
         DelayTime = 1;
      } else {
         DelayTime = newDelay;
      } /* endif */
   }


   /**
    * Returns the dely time of this thread.
    * @see #setDelayTime
    */
   public long getDelayTime()
   {
      return DelayTime;
   }


   /**
    * Adds the specified action listener to receive action events
    * from this button.
    * @param l the action listener
    */
   public void addActionListener(ActionListener l)
   {
      actionListener = AWTEventMulticaster.add(actionListener, l);
   }


   /**
    * Removes the specified action listener so it no longer receives
    * action events from this button.
    * @param l the action listener
    */
   public void removeActionListener(ActionListener l)
   {
      actionListener = AWTEventMulticaster.remove(actionListener, l);
   }


   /**
    * Fires an action event to the listeners.
    * @see #setActionCommand
    */
   public void sourceActionEvent()
   {
      if (actionListener != null)
         actionListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, actionCommand));
   }
}
